﻿//////////////////////////////////////////////
// JpgCompressionUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages::jpg
{
	class JpgBitWriter ;
}

/// Includes ---------------------------------

// nkImages
#include "../Data/JpgHuffmanTable.h"

// Standards
#include <vector>

/// Class ------------------------------------

namespace nkImages::jpg
{
	class JpgCompressionUtils
	{
		public :

			// Dct
			static void dct8x8 (float* in, float* out) ;

			// Huffman
			static std::vector<unsigned int> buildHuffmanEncodingLut (nkMemory::BufferView<const unsigned char> table, nkMemory::BufferView<const unsigned char> perBitsCounts) ;

			// Encoding
			static std::pair<int, unsigned int> getCodeFromDc (int code) ;
			static void encodeMcu (JpgBitWriter& bitWriter, float* mcu, int* outputMcu, int& lastDcValue, const unsigned char* quantizationTable, const std::vector<unsigned int>& dcHuffmanLut, const std::vector<unsigned int>& acHuffmanLut) ;
	} ;
}